/*******************************************************************************
*
*                   Copyright 2003,MARVELL SEMICONDUCTOR ISRAEL, LTD.
* THIS CODE CONTAINS CONFIDENTIAL INFORMATION OF MARVELL.
* NO RIGHTS ARE GRANTED HEREIN UNDER ANY PATENT, MASK WORK RIGHT OR COPYRIGHT
* OF MARVELL OR ANY THIRD PARTY. MARVELL RESERVES THE RIGHT AT ITS SOLE
* DISCRETION TO REQUEST THAT THIS CODE BE IMMEDIATELY RETURNED TO MARVELL.
* THIS CODE IS PROVIDED "AS IS". MARVELL MAKES NO WARRANTIES, EXPRESSED,
* IMPLIED OR OTHERWISE, REGARDING ITS ACCURACY, COMPLETENESS OR PERFORMANCE.
*
* MARVELL COMPRISES MARVELL TECHNOLOGY GROUP LTD. (MTGL) AND ITS SUBSIDIARIES,
* MARVELL INTERNATIONAL LTD. (MIL), MARVELL TECHNOLOGY, INC. (MTI), MARVELL
* SEMICONDUCTOR, INC. (MSI), MARVELL ASIA PTE LTD. (MAPL), MARVELL JAPAN K.K.
* (MJKK), MARVELL SEMICONDUCTOR ISRAEL. (MSIL),  MARVELL TAIWAN, LTD. AND
* SYSKONNECT GMBH.
********************************************************************************
* mvOsLinux.h - O.S. interface header file for Linux  
*
* DESCRIPTION:
*       This header file contains OS dependent definition under Linux
*
* DEPENDENCIES:
*       Linux kernel header files.
*
* FILE REVISION NUMBER:
*       $Revision: 1.1 $
*******************************************************************************/

#ifndef __INCmvOsLinuxh
#define __INCmvOsLinuxh

/* Includes */
#include <linux/config.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/kernel.h>
#include <linux/timer.h>
#include <linux/mm.h>
#include <linux/interrupt.h>
#include <linux/major.h>
#include <linux/errno.h>
#include <linux/genhd.h>
#include <linux/slab.h>
#include <linux/delay.h>
#include <linux/ide.h>
#include <linux/pci.h>

#include <asm/byteorder.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm/io.h>

/* Definitions */

#define MV_DEFAULT_QUEUE_DEPTH 2
/* System dependent macro for flushing CPU write cache */
#define MV_CPU_WRITE_BUFFER_FLUSH()     wmb()

/* System dependent little endian from / to CPU conversions */
#define MV_CPU_TO_LE16(x)   cpu_to_le16(x)
#define MV_CPU_TO_LE32(x)   cpu_to_le32(x)

#define MV_LE16_TO_CPU(x)   le16_to_cpu(x)
#define MV_LE32_TO_CPU(x)   le32_to_cpu(x)

/* System dependent register read / write in byte/word/dword variants */
#define MV_REG_WRITE_BYTE(base, offset, val)    writeb(val, base + offset)
#define MV_REG_WRITE_WORD(base, offset, val)    writew(val, base + offset)
#define MV_REG_WRITE_DWORD(base, offset, val)   writel(val, base + offset)
#define MV_REG_READ_BYTE(base, offset)          readb(base + offset)
#define MV_REG_READ_WORD(base, offset)          readw(base + offset)
#define MV_REG_READ_DWORD(base, offset)         readl(base + offset)


/* Typedefs    */
typedef enum mvBoolean{MV_FALSE, MV_TRUE} MV_BOOLEAN;

/* System dependant typedefs */
typedef void            MV_VOID;
typedef u32             MV_U32;
typedef u16             MV_U16;
typedef u8              MV_U8;
typedef void            *MV_VOID_PTR;
typedef u32             *MV_U32_PTR;
typedef u16             *MV_U16_PTR;
typedef u8              *MV_U8_PTR;
typedef char            *MV_CHAR_PTR;
typedef void            *MV_BUS_ADDR_T;
typedef unsigned long   MV_CPU_FLAGS;


/* Structures  */
/* System dependent structure */
typedef struct mvOsSemaphore
{
  int notUsed;
} MV_OS_SEMAPHORE;


/* Functions (User implemented)*/

/* Semaphore init, take and release */
#define mvOsSemInit(x) MV_TRUE
#define mvOsSemTake(x)
#define mvOsSemRelease(x)

/* Interrupt masking and unmasking functions */
MV_CPU_FLAGS mvOsSaveFlagsAndMaskCPUInterrupts(MV_VOID);
MV_VOID      mvOsRestoreFlags(MV_CPU_FLAGS);

/* Delay function in micro seconds resolution */
void mvMicroSecondsDelay(MV_VOID_PTR, MV_U32);

/* System logging function */
#include "mvLog.h"
/* Enable READ/WRITE Long SCSI command only when driver is compiled for debugging */
#ifdef MV_LOGGER
#define MV_SATA_SUPPORT_READ_WRITE_LONG
#endif

#define MV_IAL_LOG_ID       3

#endif /* __INCmvOsLinuxh */
