/*******************************************************************************
*
*                   Copyright 2003,MARVELL SEMICONDUCTOR ISRAEL, LTD.
* THIS CODE CONTAINS CONFIDENTIAL INFORMATION OF MARVELL.
* NO RIGHTS ARE GRANTED HEREIN UNDER ANY PATENT, MASK WORK RIGHT OR COPYRIGHT
* OF MARVELL OR ANY THIRD PARTY. MARVELL RESERVES THE RIGHT AT ITS SOLE
* DISCRETION TO REQUEST THAT THIS CODE BE IMMEDIATELY RETURNED TO MARVELL.
* THIS CODE IS PROVIDED "AS IS". MARVELL MAKES NO WARRANTIES, EXPRESSED,
* IMPLIED OR OTHERWISE, REGARDING ITS ACCURACY, COMPLETENESS OR PERFORMANCE.
*
* MARVELL COMPRISES MARVELL TECHNOLOGY GROUP LTD. (MTGL) AND ITS SUBSIDIARIES,
* MARVELL INTERNATIONAL LTD. (MIL), MARVELL TECHNOLOGY, INC. (MTI), MARVELL
* SEMICONDUCTOR, INC. (MSI), MARVELL ASIA PTE LTD. (MAPL), MARVELL JAPAN K.K.
* (MJKK), MARVELL SEMICONDUCTOR ISRAEL. (MSIL),  MARVELL TAIWAN, LTD. AND
* SYSKONNECT GMBH.
********************************************************************************
* file_name - mvLinuxOs.c
*
* DESCRIPTION:  implementation for Linux Os layer
*
*
* DEPENDENCIES:
*   mvLinuxOs.h
*   Linux header files.
*
* FILE REVISION NUMBER:
*       $Revision: 1.3 $
*
*******************************************************************************/
/* Includes */
#include "mvOs.h"

void mvMicroSecondsDelay(MV_VOID_PTR pSataAdapter, MV_U32 usecs)
{
    MV_U32 msecs = usecs / 1000;
    MV_U32 i;        
    MV_U32 tmp = usecs % 1000;
    for (i = 0; i < msecs; i++)
    {
        udelay(1000);
    }    
    if (tmp > 0)
        udelay(tmp);
}

