/*******************************************************************************
*
*                   Copyright 2003,MARVELL SEMICONDUCTOR ISRAEL, LTD.
* THIS CODE CONTAINS CONFIDENTIAL INFORMATION OF MARVELL.
* NO RIGHTS ARE GRANTED HEREIN UNDER ANY PATENT, MASK WORK RIGHT OR COPYRIGHT
* OF MARVELL OR ANY THIRD PARTY. MARVELL RESERVES THE RIGHT AT ITS SOLE
* DISCRETION TO REQUEST THAT THIS CODE BE IMMEDIATELY RETURNED TO MARVELL.
* THIS CODE IS PROVIDED "AS IS". MARVELL MAKES NO WARRANTIES, EXPRESSED,
* IMPLIED OR OTHERWISE, REGARDING ITS ACCURACY, COMPLETENESS OR PERFORMANCE.
*
* MARVELL COMPRISES MARVELL TECHNOLOGY GROUP LTD. (MTGL) AND ITS SUBSIDIARIES,
* MARVELL INTERNATIONAL LTD. (MIL), MARVELL TECHNOLOGY, INC. (MTI), MARVELL
* SEMICONDUCTOR, INC. (MSI), MARVELL ASIA PTE LTD. (MAPL), MARVELL JAPAN K.K.
* (MJKK), MARVELL SEMICONDUCTOR ISRAEL. (MSIL),  MARVELL TAIWAN, LTD. AND
* SYSKONNECT GMBH.
********************************************************************************
* mvLinuxIalLib - Header File for Linux IAL Lib.
*
* DESCRIPTION:
*       None.
*
* DEPENDENCIES:
*       None.
*
* FILE REVISION NUMBER:
*       $Revision: 1.3 $
*
*******************************************************************************/
#ifndef __INCmvLinuxIalLibh
#define __INCmvLinuxIalLibh

#include "mvLinuxIalHt.h"

#if LINUX_VERSION_CODE < KERNEL_VERSION (2,4,23)
#define irqreturn_t         void
#define IRQ_RETVAL(foo)
#endif
#define MV_LINUX_ASYNC_TIMER_PERIOD       ((MV_IAL_ASYNC_TIMER_PERIOD * HZ) / 1000)

struct pci_dev;
struct IALAdapter;
struct IALHost;


/* Adapter Initialization */
int mv_ial_lib_allocate_edma_queues(struct IALAdapter *pAdapter);

void mv_ial_lib_free_edma_queues(struct IALAdapter *pAdapter);

int mv_ial_lib_init_channel(struct IALAdapter *pAdapter, MV_U8 channelNum);

void mv_ial_lib_free_channel(struct IALAdapter *pAdapter, MV_U8 channelNum);


/* PRD Table Generation */
#define MV_PRD_TABLE_SIZE                   64 /* 64 entries max in PRD table */


int mv_ial_lib_prd_destroy(struct IALHost *pHost);
int mv_ial_lib_prd_init(struct IALHost *);



int mv_ial_lib_generate_prd(MV_SATA_ADAPTER *pMvSataAdapter, Scsi_Cmnd *SCpnt,
                            MV_SATA_EDMA_PRD_ENTRY **ppPRD_table,
                            dma_addr_t *pPRD_dma_address,
                            unsigned int *pPrd_size, dma_addr_t *pBusaddr);


/* Interrupt Service Routine*/
irqreturn_t mv_ial_lib_int_handler (int irq, void *dev_id, struct pt_regs *regs);


/* Event Notification */
MV_BOOLEAN mv_ial_lib_udma_command_completion_call_back(MV_SATA_ADAPTER *pMvSataAdapter,
                                           MV_U8 channelNum,
                                           MV_COMPLETION_TYPE comp_type,
                                           void *commandId,
                                           MV_U16 responseFlags,
                                           MV_U32 timeStamp,
                                           MV_STORAGE_DEVICE_REGISTERS *registerStruct);

MV_BOOLEAN mv_ial_lib_event_notify(MV_SATA_ADAPTER *pMvSataAdapter, MV_EVENT_TYPE eventType,
                             MV_U32 param1, MV_U32 param2);
void asyncStartTimerFunction(unsigned long data);

/* SCSI done queuing and callback */
void mv_ial_lib_add_done_queue (struct IALAdapter *pAdapter,
                                MV_U8 channel,
                                Scsi_Cmnd   *scsi_cmnd);

Scsi_Cmnd * mv_ial_lib_get_first_cmnd (struct IALAdapter *pAdapter,
                                       MV_U8 channel);

void mv_ial_lib_do_done (Scsi_Cmnd *cmnd);

void mv_ial_block_requests(struct IALAdapter *pAdapter, MV_U8 channelIndex);

#endif /* __INCmvLinuxIalLibh */
