#!/bin/sh

kversion=`uname -r`
kversion=${kversion:0:3}
#force CC to check - in
if [ "$kversion" == "2.4" ] ; then
        driver_file_name="mv_sata.o"
        cp -f Makefile_2_4 Makefile
        first_pass=0
else
        if [ "$kversion" == "2.6" ] ; then
                driver_file_name="mv_sata.ko"
                cp -f Makefile_2_6 Makefile
                first_pass=1
        else
                echo "Kernel version ${kversion} not supported"
                exit
        fi
fi

cputype=`uname -m`

if [ "$cputype" == "x86_64" ] ; then
    mcmodel="-mcmodel=kernel"
fi

echo  "Generate driver for Marvell PCI-X to Serial ATA adapters - kernel version ${kversion}."
for targetDir in 'DebugFull' 'DebugError' 'Free'; do
    case $targetDir in
           DebugFull)   logLevel=-DMV_LOG_DEBUG ;;
           DebugError)  logLevel=-DMV_LOG_ERROR ;;
           Free)  logLevel="" ;;
    esac
    mkdir -p ./../build/Linux/${targetDir}
    make clean
    echo "Compiling ${targetDir}..."
    make -s "CFLAGS_EXTRA=${logLevel} ${mcmodel}" "FIRST_PASS=${first_pass}"
    if [ ! -f mv_sata.o ] ; then
            echo "failed to make ${driver_file_name} from ${inc}${arch}"
            exit 1
    fi
    cp -f ${driver_file_name} ./../build/Linux/${targetDir}
    if [ $? -ne 0 ]; then
        echo "failed to copy ${driver_file_name} to ./../build/Linux/${targetDir}"
        exit 1
    fi
done







