#!/bin/sh
echo  "Generate modules.cgz for Marvell PCI-X to Serial ATA adapters."

if [ -z "$1" ] ; then
   echo "parameter missing"
   exit 1
fi

cp -f ../Makefile_2_4 ../Makefile
dir=`pwd`
rm -rf temp
mkdir -p temp
mkdir -p files

for inc in $(ls -1 ${1}) ; do	
	target=${inc#linux-}
	echo "target = ${target}"	
	for arch in '' 'BOOT' 'smp' 'bigmem'; do			
		echo "Creating ${target}${arch}..."
		rm -rf temp/${target}${arch}
		mkdir -p temp/${target}${arch}
		cd ..		
		make clean
		echo "Compiling ${target}${arch}..."
		if [ -z "$arch" ] ; then
			make -s "KERN_HEADERS=${1}/${inc}"
		else
			make -s "CFLAGS_EXTRA= -D__module__${arch}" "KERN_HEADERS=${1}/${inc}"	
			
		fi

		if [ ! -f mv_sata.o ] ; then
			echo "failed to make mv_sata.o from ${inc}${arch}"
			exit 1
		fi

		cp -f mv_sata.o ${dir}/temp/${target}${arch}
		if [ $? -ne 0 ]; then
			echo "failed to copy mv_sata.o to ${target}/${arch}"
			exit 1
		fi


		cd ${dir}		
	done		
done

cd ${dir}/temp

echo "Modules list:"
ls -1 -R */*.o
find .

# Remove old modules.cgz (if exists)
rm -f modules.cgz

# create modules.cgz
find .|cpio -o -Hcrc|gzip -9> modules.cgz
if [ $? -ne 0 ]; then
   echo "failed to create modules.cgz"
   exit 1
fi
mv modules.cgz ${dir}/files
cd ..
rm -rf temp
echo "modules.cgz created successfully."




