#!/bin/sh
echo  "Generate driver for Marvell PCI-X to Serial ATA adapters."
mkdir ./../build
mkdir ./../build/Linux

for targetDir in 'DebugFull' 'DebugError' 'Free'; do                        
    do case $targetDir in
           DebugFull)   logLevel=-DMV_DEBUG_LOG ;;
           DebugError)  logLevel=-DMV_DEBUG_ERROR ;;
           Free)  logLevel="" ;;                   
    esac
        done
    mkdir ./../build/Linux/${targetDir}
    make clean
    echo "Compiling ${targetDir}..."    
    make -s "CFLAGS_EXTRA=${logLevel}"
    if [ ! -f mv_sata.o ] ; then
            echo "failed to make mv_sata.o from ${inc}${arch}"
            exit 1
    fi
    
    cp -f mv_sata.o ../build/Linux/${targetDir}
    if [ $? -ne 0 ]; then
        echo "failed to copy mv_sata.o to ../build/Linux/${targetDir}"
        exit 1
    fi          
done            







