/*******************************************************************************
*
*                   Copyright 2003,MARVELL SEMICONDUCTOR ISRAEL, LTD.
* THIS CODE CONTAINS CONFIDENTIAL INFORMATION OF MARVELL.
* NO RIGHTS ARE GRANTED HEREIN UNDER ANY PATENT, MASK WORK RIGHT OR COPYRIGHT
* OF MARVELL OR ANY THIRD PARTY. MARVELL RESERVES THE RIGHT AT ITS SOLE
* DISCRETION TO REQUEST THAT THIS CODE BE IMMEDIATELY RETURNED TO MARVELL.
* THIS CODE IS PROVIDED "AS IS". MARVELL MAKES NO WARRANTIES, EXPRESSED,
* IMPLIED OR OTHERWISE, REGARDING ITS ACCURACY, COMPLETENESS OR PERFORMANCE.
*
* MARVELL COMPRISES MARVELL TECHNOLOGY GROUP LTD. (MTGL) AND ITS SUBSIDIARIES,
* MARVELL INTERNATIONAL LTD. (MIL), MARVELL TECHNOLOGY, INC. (MTI), MARVELL
* SEMICONDUCTOR, INC. (MSI), MARVELL ASIA PTE LTD. (MAPL), MARVELL JAPAN K.K.
* (MJKK), MARVELL SEMICONDUCTOR ISRAEL. (MSIL),  MARVELL TAIWAN, LTD. AND
* SYSKONNECT GMBH.
********************************************************************************
* mvIALCommonUtils.h
*
* DESCRIPTION:
*       H implementation for IAL's extension utility functions.
*
* DEPENDENCIES:
*   mvSata.h
*   mvStorageDev.h
*
*******************************************************************************/
#ifndef __INCmvIALCommonUtilsh
#define __INCmvIALCommonUtilsh

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* includes */
#include "mvSata.h"
#include "mvStorageDev.h"

/* defines */
#define MV_IAL_COMMON_LOG_ID            2

/* typedefs */
    typedef struct serialATACapabilites
    {
        MV_BOOLEAN  SATA_GEN_I_supported;
        MV_BOOLEAN  SATA_GEN_II_supported;
        MV_BOOLEAN  NCQSupported;/*native command queuing*/
        MV_BOOLEAN  RxHostInitiatedPMSupported;/* Supports receipt of host-initiated
                                                  interface power management
                                                  requests*/
        MV_BOOLEAN  TxDeviceInitiatedPMSupported;/* device supports initiating
                                                    interface power management*/
        MV_BOOLEAN  TxDeviceInitiatedPMEnabled;
        MV_BOOLEAN  DMASetupAutoActiveSupported;/* supports DMA Setup Auto-Activate
                                                   optimization*/
        MV_BOOLEAN  DMASetupAutoActiveEnables;
        MV_BOOLEAN  NonZeroBufferOffsetSupported;/* supports non-zero buffer offsets
                                                    in DMA Setup FIS*/
        MV_BOOLEAN  NonZeroBufferOffsetEnabled;
    }SERIAL_ATA_CAPABILITIES;

    typedef struct ATAIdentifyInfo
    {
        MV_U32          version;
        MV_U16          model[IDEN_MODEL_SIZE];
        MV_U16          firmware[IDEN_FIRMWARE_SIZE];
        MV_U8           UdmaMode;
        MV_U8           PIOMode;
        MV_BOOLEAN      LBA48Supported;/* used for READ/WRITE commands*/
        MV_BOOLEAN      writeCacheSupported;
        MV_BOOLEAN      writeCacheEnabled;
        MV_BOOLEAN      readAheadSupported;
        MV_BOOLEAN      readAheadEnabled;
        MV_BOOLEAN      DMAQueuedModeSupported;
        MV_U8           DMAQueuedModeDepth;
        MV_U32          ATADiskSize;
        SERIAL_ATA_CAPABILITIES SATACapabilities;/*valid only for ATA-7 or higher*/
    } ATA_IDENTIFY_INFO;


    typedef struct mvSataPMDeviceInfo
    {
        MV_U16      vendorId;
        MV_U16      deviceId;
        MV_U8       productRevision;
        MV_U8       PMSpecRevision;
        MV_U8       numberOfPorts;
    } MV_SATA_PM_DEVICE_INFO;


    MV_BOOLEAN mvParseIdentifyResult(MV_U16_PTR  iden,ATA_IDENTIFY_INFO *pIdentifyInfo);

    MV_SATA_DEVICE_TYPE mvGetSataDeviceType(MV_STORAGE_DEVICE_REGISTERS *mvStorageDevRegisters);

    MV_BOOLEAN mvInitSataDisk(MV_SATA_ADAPTER   *pSataAdapter, MV_U8 channelIndex,
                              MV_U8 PMPort, ATA_IDENTIFY_INFO   *pIdentifyInfo,
                              MV_U16_PTR identifyBuffer
                             );

    MV_BOOLEAN  mvGetPMDeviceInfo(MV_SATA_ADAPTER   *pSataAdapter,
                                  MV_U8 channelIndex,
                                  MV_SATA_PM_DEVICE_INFO *pPMDeviceInfo);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __INCmvIALCommonh */

