/*******************************************************************************
*
*                   Copyright 2003,MARVELL SEMICONDUCTOR ISRAEL, LTD.
* THIS CODE CONTAINS CONFIDENTIAL INFORMATION OF MARVELL.
* NO RIGHTS ARE GRANTED HEREIN UNDER ANY PATENT, MASK WORK RIGHT OR COPYRIGHT
* OF MARVELL OR ANY THIRD PARTY. MARVELL RESERVES THE RIGHT AT ITS SOLE
* DISCRETION TO REQUEST THAT THIS CODE BE IMMEDIATELY RETURNED TO MARVELL.
* THIS CODE IS PROVIDED "AS IS". MARVELL MAKES NO WARRANTIES, EXPRESSED,
* IMPLIED OR OTHERWISE, REGARDING ITS ACCURACY, COMPLETENESS OR PERFORMANCE.
*
* MARVELL COMPRISES MARVELL TECHNOLOGY GROUP LTD. (MTGL) AND ITS SUBSIDIARIES,
* MARVELL INTERNATIONAL LTD. (MIL), MARVELL TECHNOLOGY, INC. (MTI), MARVELL
* SEMICONDUCTOR, INC. (MSI), MARVELL ASIA PTE LTD. (MAPL), MARVELL JAPAN K.K.
* (MJKK), MARVELL SEMICONDUCTOR ISRAEL. (MSIL),  MARVELL TAIWAN, LTD. AND
* SYSKONNECT GMBH.
********************************************************************************
* mvLog.h - Header File for CORE driver logger
*
* DESCRIPTION:
*       None.
*
* DEPENDENCIES:
*
*******************************************************************************/
#ifndef __INCmvLogh
#define __INCmvLogh

#ifdef __cplusplus
extern "C" /*{*/
#endif /* __cplusplus */

/*-------------H file-----------------------------*/
#define MV_DEBUG_FATAL_ERROR                    0x01
#define MV_DEBUG_ERROR                          0x02
#define MV_DEBUG_INIT                           0x04
#define MV_DEBUG_INTERRUPTS                     0x08
#define MV_DEBUG_SATA_LINK                      0x10
#define MV_DEBUG_UDMA_COMMAND                   0x20
#define MV_DEBUG_NON_UDMA_COMMAND               0x40
#define MV_DEBUG_PM                             0x80
#define MV_DEBUG                                0x100



#define MV_MAX_LOG_MODULES         16
#define MV_MAX_MESSAGE_TYPE        9
#define MV_RAW_MSG_ID              0xF

typedef struct
{
    MV_BOOLEAN      used;
    MV_U32          filterMask;
    char            *name;
    char            *filters;
} MV_LOG_FILTER_HEADER;


#if defined (MV_LOG_DEBUG) || defined (MV_LOG_ERROR)
    #define MV_LOGGER       1
    #if defined (WIN32)
ULONG
_cdecl
DbgPrint(
        PCH Format,
        ...
        );
        #define MV_LOG_PRINT    DbgPrint
    #elif defined (LINUX)
        #define MV_LOG_PRINT    printk
    #else
        #define MV_LOG_PRINT	printf
    #endif


MV_BOOLEAN mvLogRegisterModule(MV_U8 moduleId, MV_U32 filterMask, char* name);
MV_BOOLEAN mvLogSetModuleFilter(MV_U8 moduleId, MV_U32 filterMask);
MV_U32 mvLogGetModuleFilter(MV_U8 moduleId);
void mvLogMsg(MV_U8 moduleId, MV_U32 type, char* format, ...);

#else /*defined (MV_LOG_DEBUG) || defined (MV_LOG_ERROR)*/

    #undef MV_LOGGER

    #if defined (WIN32)
        #define MV_LOG_PRINT
        #define mvLogRegisterModule
        #define mvLogGetModuleFilter
        #define mvLogRegisterAllModules
        #define mvLogMsg

    #elif defined (LINUX)
        #define MV_LOG_PRINT(x...)
        #define mvLogRegisterModule(x...)
        #define mvLogSetModuleFilter(x...)
        #define mvLogGetModuleFilter(x...)
        #define mvLogRegisterAllModules(x...)
        #define mvLogMsg(x...)

    #else
        #define MV_LOG_PRINT
        #define mvLogRegisterModule
        #define mvLogSetModuleFilter
        #define mvLogGetModuleFilter
        #define mvLogRegisterAllModules
        #define mvLogMsg
    #endif

#endif /*!defined (MV_LOG_DEBUG) && !defined (MV_LOG_ERROR)*/

#ifdef __cplusplus

/*}*/
#endif /* __cplusplus */

#endif

