/*******************************************************************************
*
*                   Copyright 2003,MARVELL SEMICONDUCTOR ISRAEL, LTD.
* THIS CODE CONTAINS CONFIDENTIAL INFORMATION OF MARVELL.
* NO RIGHTS ARE GRANTED HEREIN UNDER ANY PATENT, MASK WORK RIGHT OR COPYRIGHT
* OF MARVELL OR ANY THIRD PARTY. MARVELL RESERVES THE RIGHT AT ITS SOLE
* DISCRETION TO REQUEST THAT THIS CODE BE IMMEDIATELY RETURNED TO MARVELL.
* THIS CODE IS PROVIDED "AS IS". MARVELL MAKES NO WARRANTIES, EXPRESSED,
* IMPLIED OR OTHERWISE, REGARDING ITS ACCURACY, COMPLETENESS OR PERFORMANCE.
*
* MARVELL COMPRISES MARVELL TECHNOLOGY GROUP LTD. (MTGL) AND ITS SUBSIDIARIES,
* MARVELL INTERNATIONAL LTD. (MIL), MARVELL TECHNOLOGY, INC. (MTI), MARVELL
* SEMICONDUCTOR, INC. (MSI), MARVELL ASIA PTE LTD. (MAPL), MARVELL JAPAN K.K.
* (MJKK), MARVELL SEMICONDUCTOR ISRAEL. (MSIL),  MARVELL TAIWAN, LTD. AND
* SYSKONNECT GMBH.
*
********************************************************************************
* mvLog - C File for implementation of the core driver logger
*
* DESCRIPTION:
*       None.
*
* DEPENDENCIES:
*
*******************************************************************************/
#include "mvOs.h"


#if defined (MV_LOG_DEBUG) || defined (MV_LOG_ERROR)

char* mvLogMsgType[MV_MAX_MESSAGE_TYPE] = {
    " (FATAL_ERROR) ",
    " (ERROR) ",
    " (DEBUG INIT) ",
    " (DEBUG_INTERRUPTS) ",
    " (DEBUG SATA LINK) ",
    " (DEBUG UDMA COMMAND) ",
    " (DEBUG NON UDMA COMMAND) ",
    " (DEBUG_PM) ",
    " (DEBUG) ",
};

static MV_LOG_FILTER_HEADER mvLogInstance[MV_MAX_LOG_MODULES] =
{
    {MV_FALSE, 0, NULL},
    {MV_FALSE, 0, NULL},
    {MV_FALSE, 0, NULL},
    {MV_FALSE, 0, NULL},
    {MV_FALSE, 0, NULL},
    {MV_FALSE, 0, NULL},
    {MV_FALSE, 0, NULL},
    {MV_FALSE, 0, NULL},
};

static char szMessageBuffer[1024];


MV_BOOLEAN mvLogRegisterModule(MV_U8 moduleId, MV_U32 filterMask, char* name)
{
    if (moduleId >= MV_MAX_LOG_MODULES)
    {
        return MV_FALSE;
    }
    if (mvLogInstance[moduleId].used == MV_TRUE)
    {
        return MV_FALSE;
    }
    if (name == NULL)
    {
        return MV_FALSE;
    }
    mvLogInstance[moduleId].filterMask = filterMask;
    mvLogInstance[moduleId].name = name;
    mvLogInstance[moduleId].used = MV_TRUE;
    return MV_TRUE;
}

MV_BOOLEAN mvLogSetModuleFilter(MV_U8 moduleId, MV_U32 filterMask)
{
    if (moduleId >= MV_MAX_LOG_MODULES)
    {
        return MV_FALSE;
    }
    if (mvLogInstance[moduleId].used == MV_FALSE)
    {
        return MV_FALSE;
    }
    mvLogInstance[moduleId].filterMask = filterMask;
    return MV_TRUE;
}


MV_U32 mvLogGetModuleFilter(MV_U8 moduleId)
{
    if (moduleId >= MV_MAX_LOG_MODULES)
    {
        return 0;
    }
    if (mvLogInstance[moduleId].used == MV_FALSE)
    {
        return 0;
    }
    return mvLogInstance[moduleId].filterMask;
}

void mvLogMsg(MV_U8 moduleId, MV_U32 type, char* format, ...)
{
    int len;
    va_list args;

    if (moduleId >= MV_MAX_LOG_MODULES)
    {
        return;
    }
    if ((moduleId != MV_RAW_MSG_ID) &&
        ((mvLogInstance[moduleId].used == MV_FALSE) ||
         ((mvLogInstance[moduleId].filterMask & type) == 0)))
    {
        return;
    }
    if ((moduleId != MV_RAW_MSG_ID) && (type & 0x1ff))
    {
        MV_U8 msgType = 0;
        /* find least significant 1*/
        while (msgType < MV_MAX_MESSAGE_TYPE)
        {
            if (type & ( 1 << msgType))
            {
                break;
            }
            msgType++;
        }
        len = sprintf(szMessageBuffer, "%s%s",
                      mvLogInstance[moduleId].name, mvLogMsgType[msgType]);
    }
    else
    {
        len = 0;
    }
    va_start(args, format);
    vsprintf(&szMessageBuffer[len], format, args);
    va_end(args);
    MV_LOG_PRINT(szMessageBuffer);
}
#endif
